<?php

/* Check the absolute path to the Social Auto Poster directory. */
if ( !defined( 'SAP_APP_PATH' ) ) {
    // If SAP_APP_PATH constant is not defined, perform some action, show an error, or exit the script
    // Or exit the script if required
    exit();
}
$threads_count = isset($networks_count['threads'])?$networks_count['threads']:"";

?>
<div class="tab-pane <?php echo ( $active_tab == "threads") ? "active" : "" ?>" id="threads">
    <form id="threads-settings" class="form-horizontal" method="POST" action="<?php echo SAP_SITE_URL . '/settings/save/'; ?>" enctype="multipart/form-data"> 
        
        <?php 
        global $sap_common;
        // if Thread app id is not empty reset session data
        if (isset($_GET['threads_reset_user']) && $_GET['threads_reset_user'] == '1' && !empty($_GET['sap_threads_userid'])) {
            $threads->sap_fb_reset_session_for_threads();
        }

        //getting threads App Method account
        $threads_app_accounts = $this->sap_get_threads_fb_app_accounts();
        
        $sap_threads_options  = $this->get_user_setting('sap_threads_options');
          
        // Getting threads app grant data
        $sap_fb_sess_data_for_threads = $this->get_user_setting('sap_fb_sess_data_for_threads');

        ?>
        <div class="box box-primary border-b">
            <div class="box-header sap-settings-box-header"><?php echo $sap_common->lang('threads_general_title'); ?></div>
            <div class="box-body">
                <div class="sap-box-inner">
                    <div class="form-group mb-0">
                        <label for="" class="col-sm-3 control-label"><?php echo $sap_common->lang('threads_autoposting'); ?></label>
                        <div class="tg-list-item col-sm-6">
                            <input class="tgl tgl-ios" name="sap_threads_options[enable_threads]" id="enable_threads" <?php echo!empty($sap_threads_options['enable_threads']) ? 'checked="checked"' : ''; ?> type="checkbox" value="1">
                            <label class="tgl-btn float-right-cs-init" for="enable_threads"></label>
                            <span><?php echo $sap_common->lang('threads_autoposting_help'); ?></span>
                        </div>
                        <div class="col-sm-12 pt-40">
                            <button type="submit" name="sap_threads_submit" class="btn btn-primary sap-threads-submit"><i class="fa fa-inbox"></i> <?php echo $sap_common->lang('save'); ?></button>
                        </div>
                    </div>
                </div>
            </div>
            
        </div>


        <div class="box box-primary">
            <div class="box-header sap-settings-box-header"><?php echo $sap_common->lang('threads_api_setting'); ?></div>

            <div id="facebook-app-method" class="sap-box-inner">
            
               <?php
                 if(  $threads_count > 0) {
                    $limit_note = '';
                    
                    if($threads_count < 2) {

                        $limit_note = sprintf($sap_common->lang('single_account_limit_note'),'<span class="limit-note"><strong>','</strong></span>',$threads_count);
                    } else if($threads_count > 1) {
                        $limit_note = sprintf($sap_common->lang('max_account_limit_note'),'<span class="limit-note"><strong>','</strong></span>',$threads_count);
                    }
                    ?>
                    <div class="alert alert-info linkedin-multi-post-note count-limit-msg gmb-count-msg-limit"><?php echo $limit_note ?></div> <br>
              <?php
             }
             ?>
             
             <?php
               
                if( count($threads_app_accounts) >= $threads_count && $threads_count > 0 ){
                   $limit_alert = '';
                    if($threads_count < 2) {

                        $limit_alert = sprintf($sap_common->lang('single_account_limit_alert'),'<span class="limit-note">','</span>',$threads_count);
                    } else if($threads_count > 1) {
                        $limit_alert = sprintf($sap_common->lang('max_account_limit_alert'),'<span class="limit-note">','</span>',$threads_count);
                    }
                    ?>
                        <div class="sap-alert-error-box limit_reached"><?php echo $limit_alert; ?></div>
                    <?php
                }else{
                    if (!empty($threads_app_accounts)) {
                        echo '<div class="fb-btn">';
                    }

                    echo '<p><a class="sap-grant-fb-android btn btn-primary sap-api-btn"  href="' . $threads->sap_auto_poster_get_fb_app_method_login_url() . '"> '.$sap_common->lang("threads_add_account").' </a></p>';
                    if (!empty($threads_app_accounts)) {
                        echo '</div>';
                    }
                }
     
                if ( !empty($threads_app_accounts) ) {
                    ?>

                    <div class="form-group form-head">
                        <label class="col-md-3 "><?php echo $sap_common->lang('user_id'); ?></label>
                        <label class="col-md-3 "><?php echo $sap_common->lang('account_name'); ?></label>
                        <label class="col-md-3 "><?php echo $sap_common->lang('action'); ?></label>
                    </div>  
                    <?php
                    $i = 0;
                    foreach ($threads_app_accounts as $threads_app_key => $threads_app_value) {
                        if (is_array($threads_app_value)) {
                            $threads_user_data = $threads_app_value;
                            $app_reset_url = '?threads_reset_user=1&sap_threads_userid=' . $threads_app_key;
                            ?>
                            <div class="form-group form-deta">
                                <div class="col-md-3 "><?php print $threads_app_key; ?></div>
                                <div class="col-md-3 "><?php print $threads_user_data['name']; ?></div>
                                <div class="col-md-3 delete-account">
                                    <a href="<?php print $app_reset_url; ?>"><?php echo $sap_common->lang('delete_account'); ?></a>
                                </div>
                            </div>
                            <?php
                        }
                    }
                }    
                
                ?>

            </div>
        </div>    
        <div class="box box-primary" style="margin-top: 30px;">
			<div class="box-header sap-settings-box-header">
                <?php echo $sap_common->lang('autopost_to_threads'); ?>
            </div>
			<div class="box-body">
				<div class="sap-box-inner sap-api-threads-autopost">
					<div class="form-group in-selector">
						<label for="threads-post-users" class="col-sm-3 control-label"><?php echo $sap_common->lang('autopost_to_threads_users'); ?></label>
						<div class="col-sm-6">
                            <?php $fb_accounts = $threads->sap_get_fb_threads_accounts('all_app_users_with_name'); ?>
							<select class="form-control sap_select" multiple="multiple" name="sap_threads_options[posts_users][]">
							    <?php
                                    
                                    if (!empty($fb_accounts) && is_array($fb_accounts)) {
                                        $fb_type_post_user = (!empty($sap_threads_options['posts_users'])) ? $sap_threads_options['posts_users'] : array();
                                        $threads_count =1;
                                        foreach ($fb_accounts as $aid => $aval) {
                                            if( $threads_count > $threads_count && $threads_count >0){
                                                break;
                                            }
                                            $threads_count++;


                                            if (is_array($aval)) {

                                                $threads_app_data = isset($sap_fb_sess_data_for_threads[$aid]) ? $sap_fb_sess_data_for_threads[$aid] : array();
                                                $threads_user_data = isset($threads_app_data['sap_threads_user_cache']) ? $threads_app_data['sap_threads_user_cache'] : array();
                                                $threads_opt_label = !empty($threads_user_data['name']) ? $threads_user_data['name'] . ' - ' : '';
                                                $threads_opt_label = $threads_opt_label . $aid;
                                                ?>
                                                <optgroup label="<?php echo $threads_opt_label; ?>">

                                                    <?php foreach ($aval as $aval_key => $aval_data) { ?>
                                                        <option <?php echo in_array($aval_key, $fb_type_post_user) ? 'selected="selected"' : ''; ?> value="<?php echo $aval_key; ?>" ><?php echo $aval_data; ?></option>
                                                    <?php } ?>

                                                </optgroup>

                                            <?php } else { ?>
                                                <option <?php echo in_array($aid, $fb_type_post_user) ? 'selected="selected"' : ''; ?> value="<?php echo $aid; ?>" ><?php echo $aval; ?></option>
                                                <?php
                                            }
                                        } // End of foreach
                                    } // End of main if
                                    ?>
							</select>
                            <span><?php echo $sap_common->lang('autopost_to_threads_users_help'); ?></span>
                            <div class="button-Select sap-mt-1">
                                <button type="button" name="sap_facebook_submit" class="btn btn-primary select_all m-r-10 " data-parent="in-selector"> <?php echo $sap_common->lang('select_all'); ?></button>
                                <button type="button" class="btn btn-light deselect_all" data-parent="in-selector"><?php echo $sap_common->lang('select_none'); ?></button>
                            </div>
						</div>
					</div>
                    
                    <div class="form-group">
                        <label for="app-setting" class="col-sm-3 control-label"><?php echo $sap_common->lang('share_posting_type'); ?></label>

                            <div class='col-sm-6'>
                                <div class="tg-list-item">
                                    <?php
                                    $share_posting_type = array(
                                        "text_posting" => "Text posting",
                                        "image_posting" => "Image posting",
                                        "reel_posting" => "Video posting",
                                    );
                                    ?>
                                    <select class="sap_select sap_share_posting_type_threads" id="sap_share_posting_type"  name="sap_threads_options[share_posting_type]">          
                                        <?php
                                        $selected_share_posting_type = !empty($sap_threads_options['share_posting_type']) ? ($sap_threads_options['share_posting_type']) : 'text_posting';
                                        if (!empty($share_posting_type)) {
                                            foreach ($share_posting_type as $type => $share_posting_type) {
                                                ?>
                                                <option value="<?php echo $type ?>" <?php
                                                if ($type == $selected_share_posting_type) {
                                                    echo 'selected=selected';
                                                } else {
                                                    echo '';
                                                }
                                                ?>><?php echo $share_posting_type ?></option> 
                                                <?php
                                            }
                                        }
                                        ?>    

                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>

					<div class="form-group mb-0 show-threads-image-post">
						<label for="" class="col-sm-3 control-label"> <?php echo $sap_common->lang('threads_post_img'); ?></label>
						<div class="col-sm-6 sap-threads-img-wrap <?php echo (!empty($sap_threads_options['threads_image'])) ? 'tw-hide-uploader' : '';?>">
							<?php if( !empty( $sap_threads_options['threads_image'] ) ) { ?>
								<div class="threads-img-preview sap-img-preview">
									<img src="<?php echo SAP_IMG_URL.$sap_threads_options['threads_image']; ?>">
									<div class="cross-arrow">
										<a href="javascript:void(0)" data-upload_img=".sap-threads-img-wrap .file-input" data-preview=".threads-img-preview" title="Remove Threads Image" class="sap-setting-remove-img remove-tx-init"><i class="fa fa-close"></i></a>
									</div> 
								</div>
						    <?php } ?>
							<input id="sap_threads_img" name="threads_image" type="file" class="file file-loading <?php echo !empty( $sap_threads_options['threads_image'] )? 'sap-hide' : ''; ?>" data-show-upload="false" data-show-caption="true" data-allowed-file-extensions='["png", "jpg","jpeg", "gif"]' tabindex="15">
							<input type="hidden" class="uploaded_img" name="sap_threads_options[threads_image]" value="<?php echo !empty( $sap_threads_options['threads_image'] )? $sap_threads_options['threads_image'] : ''; ?>" >
						</div>
					</div>
			    

                    <div class="form-group show-threads-reel-post">
                        <label for="" class="col-sm-3 control-label"> <?php echo $sap_common->lang('threads_post_video'); ?></label>
                            <div class="col-sm-6 <?php echo (!empty($sap_threads_options['sap_threads_video'])) ? 'threads-hide-uploader' : '';?>">
                            <?php
                            if( !empty( $sap_threads_options['sap_threads_video'] ) ) { 
                            ?>
                                <div class="threads-video-preview">									
                                <div class="cross-arrow">
                                        <a href="javascript:void(0)" data-upload_img=".file-input" data-preview=".threads-video-preview" title="Remove Threads Video" class="sap-setting-remove-reel-threads remove-tx-init"><i class="fa fa-close"></i></a>
                                    </div>
                                    <div class="sap-quick-post-privew-video">
                                        <video width="auto" height="100%" controls>
                                            <source src="<?php echo SAP_IMG_URL.$sap_threads_options['sap_threads_video']; ?>" type="video/mp4">
                                        </video>
                                    </div>	 
                                </div>
                            <?php 
                            } ?>
                                <?php 
                                $preview_name = !empty($sap_threads_options['sap_threads_video']) ? $sap_threads_options['sap_threads_video'] : '';
                                $preview_video = !empty($sap_threads_options['sap_threads_video']) ? SAP_SITE_URL.'/uploads/'. $preview_name : '';
                                ?>
                                <input id="sap_threads_video" tabindex="3" name="sap_threads_video" value="<?php echo $preview_video; ?>" type="file" class="file file-loading threads-reel-input" data-show-upload="false" data-show-caption="true" data-max-file-size="<?php echo MINGLE_MAX_FILE_UPLOAD_SIZE; ?>" />
                                <input type="hidden" id="uploaded_video" class="threads-reel-input-hidden" name="sap_threads_options[sap_threads_video]" value="<?php echo !empty($sap_threads_options['sap_threads_video']) ? $sap_threads_options['sap_threads_video'] : ''; ?>" >
                                <h6><b>Please check allowed video formats and standards <a target="_blank" href="https://docs.wpwebelite.com/mingle-saas/social-network-configuration/#Quickshare-video">here.</a></b></h6>
                        </div>
                    </div>
                </div>

			<div class="box-footer">
				<div class="">
					<button type="submit" name="sap_threads_submit" class="btn btn-primary sap-threads-submit"><i class="fa fa-inbox"></i> <?php echo $sap_common->lang('save'); ?></button>
				</div>
			</div>
	    </div>        
    </form>
</div>