<?php

/* Check the absolute path to the Social Auto Poster directory. */
if ( !defined( 'SAP_APP_PATH' ) ) {
    // If SAP_APP_PATH constant is not defined, perform some action, show an error, or exit the script
    // Or exit the script if required
    exit();
}

$language = array(
	'SAP_NAME' => "Social Auto Poster",
	'reset_your_password' => "Reset Your Password", 
	'reset_password_help_text' => "Enter your email to send reset password link",
	'reset_btn_text' => "Reset Password",
	'back_to_login_text' => "Log in",
	'sign_in' => "Sign In",
	'forgot_password' => "Forgot password?",
	'sign_up' => "Don't have account please sing up",
	'your_details' => "Your Details",
	'your_subscription' => "Your Subscription",
	'payment_history' => "Payment History",
	'postal_code' => "Postal Code",
	'state' => "State",
	'country' => "Country",
	'city' => "City",
	'line1' => "Address Line 1",
	'line2' => "Address Line 2",
	'first_name' => "First Name",
	'first_name_plh' => "Your First Name",
	'last_name' => "Last Name",
	'last_name_plh' => "Your Last Name",
	'email' => "Email",
	'password' => "Password",
	're_password' => "Confirm Password",
	're_password_plh' => "Confirm Password",
	'submit' => "Submit",
	'customer_name' => "Customer Name",
	'membership_level' => "Membership Level",
	'allowed_network' => "Allowed Network",
	'membership_status' => "Membership Status",
	'yes' => "Yes",
	'no' => "No",
	'cancel' => "Cancel",
	'upgrade' => "Upgrade",
	'recurring' => "Recurring",
	'expiration_date' => "Expiration Date",
	'number' => "No.",
	'payment_gateway' => "Payment Gateway",
	'transaction_id' => "Transaction ID",
	'payment_status' => "Payment Status",
	'amount' => "Amount",
	'payment_date' => "Payment Date",
	'invoice' => "Invoice",
	'reset_pass_email_title' => "Set up a new password for Social Auto Poster",
	'reset_pass_email_text' => "%s Hi %s, %s %s You recently requested to reset your password for your Mingle - Social Auto Poster account. Use the button below to reset it. %s",
	'reset_pass_email_after_btn_text' => "%s If you did not request a password reset, please ignore this email. %s %s Thanks, %s The Social Auto Poster Team %s",
	'reset_pass_email_rights' => "%s %s %s Mingle - Social Auto Poster. All rights reserved %s",
	'reset_pass_enter_pass_text' => "Enter your new password below",
	'reset_pass_plh' => "New Password",
	'reset_pass_re_pass_plh' => "Re-enter new Password",
	'reset_pass_save_text' => "Save New Password",
	'reset_pass_back_login' => "Back to login",
	'sign_up' => "Sign Up",
	'choose_membership' => "Choose your membership",
	'choose_payment' => "Choose Your Payment Method",
	'signup_payment_help_text' => "Please enable at least one payment method",
	'signup_test_help_text' => "%s Test Mode Is Enabled %s %s You can use the following card details for Stripe test transactions: %s",
	'signup_card_details' => "%s%s Number: %s 4242424242424242 %s %s%s CVC: %s 123 %s %s%s Expiration: %s Any future date %s %s For more test card numbers visit the %s Stripe documentation page. %s %s",
	'signup_payment_details' => "Payment Details",
	'signup_address_details' => "Billing Details",
	'signup_card_number' => "Card Number",
	'signup_valid_card_number' => "Valid Card Number",
	'signup_expiry_date' => "Expiry Date",
	'signup_card_mm' => "MM",
	'signup_card_yy' => "YY",
	'signup_card_cvv_num' => "CVV Number",
	'signup_card_cvv_plh' => "CVV",
	'signup_auto_renew' => "Auto Renew",
	'signup_register_btn' => "Register",
	'thank_you_msg' => "Your registration is completed",
	'subscription_details' => "Subscription Details",
	'continue_login' => "Continue to Login",
	'register_license_update' => "Register License & Update",
	'current_version' => "Current Version",
	'codecanyon_access_token' => "CodeCanyon Access Token",
	'update_enter_email_plh' => "Enter your register email",
	'update_enter_license_plh' => "Enter your license key",
	'enter_codecanyon_access_token' => "Enter Codecanyon Access Token",
	'deregister_access_token' => "Deregister Access Token",
	'register_access_token' => "Register Access Token",
	'register_license' => "Register License",
	'deregister_license' => "Deregister License",
	'update' => "Update",
	'report' => "Reports",
	'show_all_st' => "Show all social type",
	'year' => "Year",
	'this_month' => "This Month",
	'last_days' => "Last 7 days",
	'custom' => "Custom",
	'filter' => "Apply Filter",
	'from_date' => "From Date",
	'to_date' => "To Date",
	'facebook_general_title' => "General Settings",
	'facebook_autoposting' => "Enable Autoposting",
	'facebook_autoposting_help' => "Enable this button, if you want to automatically post your new content to Facebook.",
	'facebook_proxy_title' => "Proxy Settings",
	'facebook_proxy_title_help' => "Enable / Disable Proxy setting for Facebook.",
	'facebook_proxy_enable' => "Enable Proxy",
	'facebook_proxy_url' => "Proxy URL",
	'facebook_proxy_url_help' => "Insert your private or public Proxy Domain URL / IP address.",
	'facebook_proxy_username' => "Proxy Username",
	'facebook_proxy_username_help' => "Insert Your proxy Username or Login ID.",
	'facebook_proxy_password' => "Proxy Password",
	'facebook_proxy_password_help' => "Insert Your proxy Password / Credentials for logins.",
	'save' => "Save",
	'facebook_api_setting' => "API Settings",
	'instagram_api_setting' => "Instagram API Settings",
	'threads_api_setting' => "Threads API Settings",
	'facebook_authentication' => "Select Authentication Type",
	'linkedin_authentication' => "Select Authentication Type",
	'tumblr_authentication' => "Select Authentication Type",
	'reddit_authentication' => "Authentication to Reddit",
	'facebook_app_method' => "Facebook APP Method",
	'linkedin_app_method' => "LinkedIn APP Method",
	'tumblr_app_method' => "Tumblr APP Method",
	'linkedin_recommnended' => "( Recommnended )",
	'facebook_graph_api' => "Facebook Graph API",
	'linkedin_graph_api' => "LinkedIn API",
	'tumblr_graph_api' => "Tumblr API",
	'facebook_add_account' => "Add Facebook Account",
	'linkedin_add_account' => "Add Linkedin Account",
	'tumblr_add_account' => "Add Tumblr Account",
	'reddit_add_account' => "Add Reddit Account",
	'user_id' => "User ID",
	'account_name' => "Account Name",
	'flair' => 'Flair',
	'action' => "Action",
	'delete_account' => "Delete Account",
	'facebook_application' => "Facebook Application",
	'facebook_graph_api_hlp_text' => "%s Before you start publishing your content to Facebook you need to create a Facebook Application. You can get a step by step tutorial for creating a Facebook Application on our %s Documentation %s. %s",
	'allowing_permissinons' => "Allowing permissions",
	'allowing_permissinons_hlp_text' => "Posting content to your chosen Facebook Page or Group requires you to grant extended permissions. If you want to use this feature you should grant the extended permissions now.",
	'facebook_app_id_key' => "Facebook App ID/API Key",
	'facebook_app_secret' => "Facebook App Secret",
	'validd_oath_uris' => "Valid OAuth redirect URIs",
	'facebook_app_id_key_plh_text' => "Enter Facebook App ID / API Key",
	'facebook_app_secret_plh_text' => "Enter Facebook App Secret",
	'valid_redirect_url' => "Valid Redirect URL",
	'copy' => "Copy",
	'allowing_permissinons_help_text' => "You already granted extended permissions.",
	'reset_user_session' => "Reset User Session",
	'grant_permission' => "Grant extended permissions",
	'add_more' => "Add more",
	'autopost_to_fb' => "Autopost Settings",
	'autopost_to_fb_users' => "Autopost Posts to Facebook of this user(s)",
	'autopost_to_fb_users_help' => "Select each of the users that you want to automatically post to Facebook when a new post is published.",
	'share_posting_type' => "Share posting type",
	'facebook_post_img' => "Facebook Post Image",
	'url_shortener' => "URL Shortener",
	'bit_access_token' => "Bit.ly Access Token",
	'shorte_api_token' => "Shorte.st API Token",
	'gmb_general_settings' => "General Settings",
	'en_autopost_gmb' => "Enable Autoposting",
	// 'en_autopost_gmb_help' => "Enable this button, if you want to automatically post your new content to Google My Business.",
	'en_autopost_gmb_help' => "Enable this button, if you want to automatically post your new content to Google Business Profile.",
	'gmb_api_setting' => "API Settings",
	// 'add_gmb_account' => "Add GMB Account",
	'add_gmb_account' => "Add GBP Account",
	'autopost_to_gmb' => "Autopost Settings",
	// 'autopost_to_gmb_users' => "Autopost Posts to Google My Business of this user(s)",
	'autopost_to_gmb_users' => "Autopost Posts to Google Business Profile of this user(s)",
	// 'autopost_to_gmb_users_help' => "Select each of the users that you want to automatically post to Google My Business when a new post is published.",
	'autopost_to_gmb_users_help' => "Select each of the users that you want to automatically post to Google Business Profile when a new post is published.",
	// 'gmb_btn_type' => "Select GMB Button Type",
	'gmb_btn_type' => "Select GBP Button Type",
	// 'gmb_post_img' => "Google My Business Post Image",
	'gmb_post_img' => "Google Business Profile Post Image",
	'li_general_setting' => "General Settings",
	'en_autopost_li' => "Enable Autoposting",
	'en_autopost_li_help' => "Enable this button, if you want to automatically post your new content to LinkedIn.",
	'li_api_setting' => "API Settings",
	'li_application' => "LinkedIn Application",
	'li_application_help_text' => "%s Before you start publishing your content to LinkedIn you need to create a LinkedIn Application. You can get a step by step tutorial on how to create a LinkedIn Application on our %s Documentation %s %s",
	'li_allowing_permissinons_hrlp_text' => "Posting content to your chosen LinkedIn personal account requires you to grant extended permissions. If you want to use this feature you should grant the extended permissions now.",
	'li_alert_notice_text' => "As LinkedIn made some changes recently, graph API have some limitation. Graph API working with old App and this option just for backwards compatibility.",
	'en_company_page' => "Enable Company Pages",
	'en_company_page_help_text' => "%sNote:%s You must have approved company account and your App with these permissions {rw_organization_admin} and {w_organization_social}",
	'li_app_id_key' => "LinkedIn App ID/API Key",
	'li_app_secret' => "LinkedIn App Secret",
	'li_app_id_key_plh_text' => "Enter LinkedIn App ID / API Key",
	'li_app_secret_plh_text' => "Enter LinkedIn App Secret.",
	'autopost_to_li' => "Autopost Settings",
	'autopost_to_li_users' => "Autopost Posts to LinkedIn of this user(s)",
	'autopost_to_li_users_help' => "Select each of the users that you want to automatically post to LinkedIn when a new post is published.",
	'li_post_img' => "LinkedIn Post Image",
	'general' => "General",
	'general_settings' => "General Settings",
	'timezone' => "Timezone",
	'select_timezone' => "Select your TIMEZONE",
	'ga_tracking' => "Google Analytics Campaign Tracking",
	'ga_tracking_help_text' => "Enable campaign tracking if you want to see how much traffic is generated by Social Auto Poster.",
	'en_social_post' => "Enable Social Posting Logs",
	'en_social_post_help_text' => 'Enable this to store your social posting activities into the database which can be viewed from "Logs" section.',
	'network_label_fb' => "Facebook",
	'network_label_twitter' => "Twitter",
	'network_label_li' => "LinkedIn",
	'network_label_tumblr' => "Tumblr",
	'network_label_pinterest' => "Pinterest",
	// 'network_label_gmb' => "Google My Business",
	'network_label_gmb' => "Google Business Profile",
	'network_label_insta' => 'Instagram',
	'network_label_threads' => 'Threads',
	'network_label_youtube' => 'Youtube',
	'network_label_reddit' => 'Reddit',
	'network_label_blogger' => 'Blogger',
	'pit_general_settings' => "General Settings",
	'pit_proxy_title' => "Proxy Settings",
	'pit_proxy_enable' => "Enable Proxy",
	'pit_proxy_enable_help' => "Enable / Disable Proxy setting for Pinterest.",
	'pit_proxy_url' => "Proxy URL",
	'pit_proxy_url_help' => "Insert your private or public Proxy Domain URL / IP address.",
	'pit_proxy_username' => "Proxy Username",
	'pit_proxy_username_help' => "Insert Your proxy Username or Login ID.",
	'pit_proxy_password' => "Proxy Password",
	'pit_proxy_password_help' => "Insert Your proxy Password / Credentials for logins.",
	'pit_authentication'   => "Select Authentication Type",
	'pit_application'   => 'Pinterest Application',
	'pit_app_method_help_text' => '%s Before you can start publishing your content to Pinterest you need to create a Pinterest Application.You can get a step by step tutorial on how to create a Pinterest Application on our %s Documentation %s. %s',
	'pit_notice_help_text' => "%sNote:%s You need to define redirect uri as mentioned below when you create Pinterest Application. Otherwise pinterest won't redirect you to the correct page after authorization. Replace {app_id} with your pinterest application key/id.",
	'en_autopost_pit' => "Enable Autoposting",
	'en_autopost_pit_help' => "Enable this button, if you want to automatically post your new content to Pinterest.",
	'pit_api_settings' => "Pinterest API Settings",
	'pit_app_id_key'         => "Enter App ID/API Key",
	'pit_app_secret'         => "Enter App Secret",
	'pin_app_id_key_plh_text' => "Enter App ID / API Key",
	'pin_app_secret_plh_text' => "Enter App Secret",
	'pit_session_id' => "Enter Session ID",
	'pit_add_account' => "Add Pinterest Account",
	'autopost_to_pit' => "Autopost Settings",
	'autopost_to_pit_users' => "Autopost Posts to Pinterest of this user(s)",
	'autopost_to_pit_users_help' => "Select each of the users that you want to automatically post to Pinterest when a new post is published",
	'pit_post_img' => "Pinterest Post Image",
	'pit_post_img_help_text' => "%s Note: %s Here you can upload a default image which will be used for the Pinterest board.",
	'twi_general_settings' => "General Settings",
	'youtube_general_settings' => "General Settings",
	'reddit_general_settings' => "General Settings",
	'en_autopost_twi' => "Enable Autoposting",
	'en_autopost_twi_help' => "Enable this button, if you want to automatically post your new content to Twitter.",
	'en_autopost_youtube' => "Enable Autoposting",
	'en_autopost_youtube_help' => "Enable this button, if you want to automatically post your new content to Youtube.",
	'en_autopost_reddit' => "Enable Autoposting",
	'en_autopost_reddit_help' => "Enable this button, if you want to automatically post your new content to Reddit.",
	'youtube_api_settings' => "API Settings",
	'youtube_application' => "Youtube Application",
	'youtube_application_help_text' => "%s Before you start publishing your content to Youtube you need to create a Google Application. You can get a step by step tutorial on how to create a Google Application on our %s Documentation %s.%s",
	'youtube_oauth_uri' => "Valid OAuth redirect URIs",
	'api_key_youtube_text' => "Enter Youtube App ID / API Key",
	'api_secret_youtube_text' => "Enter YouTube App Secret.",
	'access_token_youtube_text' => "Enter Youtube Access Token Secret.",
	'autopost_to_youtube' => "Autopost Settings",
	'autopost_to_youtube_users' => "Autopost Posts to Youtube of this user(s)",
	'autopost_to_youtube_users_help' => "Select each of the users that you want to automatically post to Youtube when a new post is published.",
	'youtube_post_video' => "Youtube Post Video",
	'insta_post_video' => "Instagram Reel Video",
	'threads_post_video' => "Threads Post Video",
	'fb_post_video' => "Facebook Reel Video",

	
	'twi_api_settings' => "API Settings",

	'twi_application' => "Twitter Application",

	'twi_application_help_text' => "%s Before you start publishing your content to Twitter you need to create a Twitter Application. You can get a step by step tutorial on how to create a Twitter Application on our %s Documentation %s.%s",
	
	'reddit_application_flair_map_help_text' => "%sNote:%s For Reddit community posting, it is required to map flair with individual community before posting.",

	'reddit_application_help_text' => "%s Before you start publishing your content to Reddit you need to create a Reddit Application. You can get a step by step tutorial on how to create a Reddit Application on our %s Documentation %s.%s",

	'reddit_api_settings' => "API Settings",
	'reddit_application' => "Reddit Application",

	'api_key' => "API Key",
	'api_key_plh_text' => "Enter Twitter API Key.",
	'api_secret' => "API Secret",
	'api_secret_plh_text' => "Enter Twitter API Secret.",
	'access_token' => "Access Token",
	'access_token_plh_text' => "Enter Twitter Access Token.",
	'access_token_secret' => "Access Token Secret",
	'access_token_secret_plh_text' => "Enter Twitter Access Token Secret.",
	'autopost_to_twi' => "Autopost Settings",
	'autopost_to_reddit' => "Autopost Settings",
	'autopost_to_twi_users' => "Autopost Posts to Twitter of this user(s)",
	'autopost_to_twi_users_help' => "Select each of the users that you want to automatically post to Twitter when a new post is published.",
	'autopost_to_reddit_users' => "Autopost Posts to Reddit of this user(s)",
	'autopost_to_reddit_users_help' => "Select each of the users that you want to automatically post to Reddit when a new post is published.",
	'dis_img_posting' => "Disable Image posting",
	'dis_img_posting_help' => "Enable this button, if you want to disable image posting for Twitter.",
	'twi_post_img' => "Twitter Post Image",
	'reddit_post_img' => "Reddit Post Image",
	'smtp_settings' => "SMTP Settings",
	'enable_disable' => "Enable/Disable",
	'smtp_enable_disable' => "SMTP Email Settings",
	'smtp_en_checkbox' => "Enable this switch to activate SMTP for sending emails from your application.",
	'from_email' => "From Email Address",
	'from_name' => "From Name",
	'smtp_host' => "SMTP Host",
	'smtp_port' => "SMTP Port",
	'smtp_username' => "SMTP Username",
	'smtp_pass' => "SMTP Password",
	'save_settings' => "Save Settings",
	'payment_gateway_settings' => "Payment Gateways Settings",
	'general_settings_tab' => "General Settings",
	'general_settings_logo_htitle' => "Site Settings",
	'upload_logo_image' => "Upload Logo image here.",
	'upload_logo' => "Upload Logo",
	'upload_favicon' => "Upload Favicon",
	'email_settings' => "Email Settings",
	'footer_setting_label' => "Add Footer Content",
	'header_setting_label' => "Add Head Content",
	'header_content_label' => "Custom Head Code",
	'css_setting_label' => "Add Custom Styling",
	'footer_content' => "Footer Content",
	'header_content' => "Header Content",
	'smtp_settings' => "SMTP Settings",
	'stripe' => "Stripe",
	'manual' => "Manual",
	'stripe_help_text' => "Check each of the payment gateways you would like to enable. Configure the selected gateways below.",
	'default_payment' => "Default Payment",
	'select_payment' => "Select Payment Method",
	'default_payment_help_text' => "Select the default payment gateway that would be checked by default while user making payments.",
	'css_content_help_text' => "Insert custom CSS code for the frontend and backend pages.",
	'header_content_help_text' => "Insert custom code into the &lt;head&gt; section for frontend and backend pages.",
	'css_content_label' => "Custom CSS Style",
	'currency' => "Currency",
	'select_currency' => "Select Currency",
	'en_test_mode' => "Enable Test Mode",
	'en_test_help_text' => "This allows you to test the Mingle with test accounts from your payment processor.",
	'label' => "Label",
	'stripe_title' => 'Title',
	'stripe_title_help_text' => 'Enter the payment gateway title here that customers can see while making payments',
	'test_publisher_key' => "Test Publishable Key",
	'test_publisher_help_text' => "Enter test publishable key here.",
	'test_secret_key' => "Test Secret Key",
	'enter_test_secret_key' => "Enter test secret key.",
	'live_publisher_key' => "Live Publishable Key",
	'enter_live_publisher_key' => "Enter live publishable key here.",
	'live_secret_key' => "Live Secret Key",
	'enter_live_secret_key' => "Enter live secret key.",
	'billing_detail_settings' => "Activate Billing Address",
	'strip_webhook_url' => "Stripe Webhook URL",
	'enable_billing_details_help_text' => "%sNote: %sCheck this box to enable billing address information field on Sign-up / Plan Upgrade billing page when using stripe.",
	'strip_webhook_url_help_text' => "%sNote: %sPlease add this URL to your stripe Webhook menu under the Developers.",
	'en_email_verif' => "Enable Email Verification",
	'en_email_verif_help_text' => "Enable this setting to send verification email to users when they signup.",
	'subscription_renewal_notif_email' => "Subscription renewal notification email",
	'subject' => "Subject",
	'subject_help_text' => "The subject line for the email sent to users when their membership becomes renew.",
	'content' => "Content",
	'footer_content' => "Footer Content",
	'footer_content_help_text' => "Add footer content for the backend.",
	'content_help_test' => "This is the email message that is sent to users when their membership becomes renew.%s %s{user_name}%s - Display Username %s %s{membership_level}%s - Display membership level %s %s{subscription_id}%s - Display stripe subscription id %s %s{plan_name}%s - Display Plan Name %s %s{expiration_date}%s - Display expiration date %s %s{sap_name}%s - SAP Product Name",
	'tumb_general_settings' => "General Settings",
	'en_autopost_tumb' => "Enable Autoposting",
	'en_autopost_tumb_help' => "Enable this button, if you want to automatically post your new content to Tumblr.",
	'post_content' => "Post Content",
	'snippets' => "Snippets",
	'full' => "Full",
	'post_content_help_text' => "Choose whether you want to post the full content or just a snippet to your Tumblr page. if you choose snippets, it will post the first 200 characters from your post.",
	'tumb_api_settings' => "API Settings",
	'tumb_application' => "Tumblr Application",
	'tumb_application_help_text' => "%sBefore you start publishing your content to Tumblr you need to create a Tumblr Application. You can get a step by step tutorial on how to create a Tumblr Application on our %s Documentation. %s",
	'tumb_oauth_consumer_key' => "Enter Consumer Key",
	'tumb_secret_key' => "Enter Secret Key",
	'autopost_to_tumb' => "Autopost Settings",
	'autopost_to_tumb_users' => "Autopost Posts to Tumblr of this user(s)",
	'autopost_to_tumb_users_help' => "Select each of the users that you want to automatically post to Tumblr when a new post is published.",
	'posting_type' => "Posting Type",
	'photo' => "Photo",
	'text' => "Text",
	'link' => "Link",
	'tumb_post_img' => "Tumblr Post Image",
	'add_new' => "Add New",
	'message' => "Message",
	'image' => "Image",
	'video' => "Enable Image/Video for posting",
	'video_label' => "Video",
	'allowed_type_size' => "Allowed video format(mp4,mkv,mov) Filesize upto 1GB",
	'quick_post_image_help_text' => "Image not post on Facebook, Your current Facebook App Version not support image",
	'networks' => "Networks",
	'quick_post_facebook_help_text' => "Please set Facebook grant extended permissions for publishing content on Facebook account.",
	'select_accounts' => "Select Accounts",
	'quick_post' => "Quick Posting",
	'quick_post_edit' => "Edit Quick Post",
	'quick_post_twi_cnofig_msg' => "Please configure Twitter account for publishing post on Twitter.",
	'quick_post_youtube_cnofig_msg' => "Please configure Youtube account for publishing post on Youtube.",
	'quick_post_reddit_cnofig_msg' => "Please configure Reddit account for publishing post on Reddit.",
	'quick_post_li_help_msg' => "Please set Linkedin grant extended permissions for publishing post on Linkedin.",
	'quick_post_li_link_msg' => "Please provide a %s link %s otherwise posting will not work for LinkedIn.",
	'quick_post_tumb_help_msg' => "Please set Tumblr grant extended permissions for publishing content on Tumblr account.",
	'quick_post_tumb_setting_msg' => "Please select aleast one account from settings for publishing on Tumblr.",
	'quick_post_blog_cnofig_msg' => "Please configure Blogger account for publishing post on Blogger.",
	'quick_post_wp_cnofig_msg' => "Please configure WordPress account for publishing post on WordPress.",
	'select_posting_type' => "Select Posting Type",
	'quick_post_pit_help_msg' => "Add atleast one account from Pinterest settings to start posting.",
	// 'quick_post_gmb_help_msg' => "Please setup atleast one account for publishing posts to Google My Business",
	'quick_post_gmb_help_msg' => "Please setup atleast one account for publishing posts to Google Business Profile",
	'select_locations' => "Select Locations",
	'select_btn_type' => "Select Button Type",
	// 'quick_post_gmb_link_msg' => "Please provide a %s link %s otherwise posting will not work for Google My Business.",
	'quick_post_gmb_link_msg' => "Please provide a %s link %s otherwise posting will not work for Google Business Profile.",
	'publish_post' => "Publish Post",
	'update_post' => "Update Post",
	'published' => "Published",
	'scheduled' => "Scheduled",
	'bulk_action' => "Bulk Action",
	'date' => "Date",
	'book' => "Book",
	'order_online' => "Order online",
	'buy' => "Buy",
	'learn_more' => "Learn more",
	'call' => "Call",
	'debug_logs_title' => "%s Posting Debug Logs %s (Debug Logs will be cleared automatically every week.)%s%s",
	'debug_logs_alert_msg' => "Are you sure you want to clear debug log?",
	'posting_logs' => "Posting Logs",
	'logs_content' => "Content",
	'social_type' => "Social Type",
	'social_posting_logs' => "Social Posting Logs",
	'close' => "Close",
	'add_customer' => "Add Customer",
	'customer_details' => "Customer Details",
	'role' => "Role",
	'user' => "User",
	'admin' => "Admin",
	'notify_user' => "Notify User?",
	'notify_user_checkbox' => "Slide to enable notification.",
	'status' => "Status",
	'payments' => "Payments",
	'select_membership_level' => "Select Membership level",
	'select_gateway' => "Select Gateway",
	'gateway' => "Gateway",
	'name' => "Name",
	'customers' => "Customers",
	'active' => "Active",
	'in-active' => "In-active",
	'select_status' => "Please select status",
	'delete' => "Delete",
	'create_account_title' => "Your account created at Social Auto Poster",
	'new_account_email_temp_username_text' => "%s Hi %s,%s %s Your account email pending to verification for the Mingle - Social Auto Poster . Please click the button below to verify your email:%s",
	'verify_now' => "Verify Now",
	'new_account_email_temp_after_btn_text' => "%sIf you can not verify your email using above button, please contact administrator.%s %sThanks,%s The Social Auto Poster Team %s",
	'new_account_email_temp_copy_rights' => "%s %s Mingle - Social Auto Poster. All rights reserved ",
	'your_subscription_details' => "Your subscription details",
	'view_invoice' => "View Invoice",
	'login_to_account' => "Login to your account",
	'new_account_user_notif_temp' => "%s Hi %s,%s %s Your account created for the Mingle - Social Auto Poster. please find your login details as below:%s",
	'username' => "Username",
	'edit_customer' => "Edit Customer",
	'update_customer' => "Update Customer",
	'user_no_exist_msg' => "The user is no longer exist in the system.",
	'membership_details' => "Membership Details",
	'recent_payments' => "Recent Payments",
	'customer_not_made_payment' => "This customer have not made any payment yet.",
	'add_membership' => "Add Membership",
	'customer' => "Customer",
	'select_customer' => "Select Customer",
	'no_expiration' => "No Expiration",
	'edit_membership' => "Edit Membership",
	'description' => "Description",
	'price' => "Price",
	'select_membership_status' => "Select Membership Status",
	'never_expire' => "Never Expire",
	'upgrade_from' => "Upgrade from",
	'update_membership' => "Update Membership",
	'Payments_not_found' => "Payments not found.",
	'pending' => "Pending",
	'expired' => "Expired",
	'cancelled' => "Cancelled",
	'duration' => "Duration in Days",
	'membership' => "Memberships",
	'customer_id' => "Customer ID",
	'created_date' => "Created Date",
	'expiration' => "Expiration",
	'subscription' => "Subscription",
	'subtotal' => "Subtotal",
	'total_price' => "Total Price",
	'payment_status' => "Payment Status",
	'ADDITIONAL_INFO' => "ADDITIONAL INFO ",
	'print' => "Print",
	'bill_to' => "Bill To",
	'subscription_renew_for' => "Subscription Renew for Social Auto Poster",
	'choose_your_membershipas' => "Choose Your Memberships",
	'no_mebership_level' => "No Mebership level exits.",
	'payment_process_msg' => "We are waiting for payment confirmation from payment processor.",
	'subscription_expired_msg' => "Your subscription has been expired wait for auto-renewal please check after some time.",
	'you_current_plan_is' => "You Current membership level is",
	'add_membership_level' => "Add Membership Level",
	'name_of_the_membership_level' => "The name of the membership level.",
	'membership_level_description' => "Enter membership level description here.",
	'price_of_membership_msg' => "The price of this membership level. Enter 0 for free. ",
	'Length_of_time' => "Length of time for this membership level enter 0 for unlimited.",
	'membership_level_details' => "Membership Level Details",
	'edit_membership_level' => "Edit Membership Level",
	'updat_membership_level' => "Update Membership level",
	'apply' => "Apply",
	'add_multi_post_content' => "Add Multi-Post Content",
	'add_content' => "Add Content",
	'content_image' => "Content Image",
	'fb_not_post_img_msg' => "Image not post on Facebook, Your current Facebook App Version not support image",
	'schedule' => "Schedule",
	'current_status_unpublished' => "%s Note: %s You can only schedule the content if the current status set to unpublished.",
	'add' => "Add",
	'edit_multi_post_content' => "Edit Multi-Post Content",
	'edit_content' => "Edit Content",
	'multi-post' => "Multi Posting",
	'post_to_facebook_account' => "Post To This Facebook Account(s)",
	'custom_link' => "Custom Link",
	'post_image' => "Post Image",
	'custom_message' => "Custom Message",
	'reddit_custom_message' => "Reddit Title",
	// 'set_gmb_msg' => "Please set Google My Business location for publishing content on Google My Business.",
	'set_gmb_msg' => "Please set Google Business Profile location for publishing content on Google Business Profile.",
	'unpublished' => "Unpublished",
	'reset_status' => "Reset Status",
	// 'post_to_gmb' => "Post To This Google My Business Locations",
	'post_to_gmb' => "Post To This Google Business Profile Locations",
	// 'provide_link_gmb' => "Please provide a %slink%s OR custom link otherwise posting will not work for Google My Business.",
	'provide_link_gmb' => "Please provide a %slink%s OR custom link otherwise posting will not work for Google Business Profile.",
	'post_to_li' => "Post To This LinkedIn Account(s)",
	'custom_title' => "Custom Title",
	'post_title' => "Post Title",	
	'pinterest_desc' => "Pinterest is an image posting platform so, you need to upload atleast one image, else posting will not work.",
	'post_to_pit' => "Post To This Pinterest Account(s)",
	'posting_type' => "Posting Type",
	'post_to_tumb' => "Post To This Tumblr Account(s)",
	'post_to_twi' => "Post To This Twitter Account(s)",
	'post_to_reddit' => "Post To This Reddit Account(s)",
	'provide_link_li' => "Please provide a %slink%s OR custom link otherwise posting will not work for LinkedIn.",
	'account_verified_msg' => "We noticed your email address has not been verified. Please verify your email first %s",
	'account_active_msg' => "We have noticed that your account is not active. Please contact administrator to activate your account.",
	'success_login_msg' => "You are successfully logged in",
	'invalid_up_msg' => "Invalid username or password",
	'profile_update_msg' => "Profile updated sucessfully",
	'error_update_msg' => "Error updating profile",
	'success_logout_msg' => "You are successfully logged out",
	'reset_password_link_email_msg' => "Reset Password link has been sent to your email account. Please check your email.",
	'email_not_sent_msg' => "Email could not sent.",
	'email_not_found_msg' => "Your email address was not found in our database.",
	'token_expired_msg' => "Your token is expired, please try again.",
	'enter_new_password_msg' => "Enter your new password.",
	're_enter_new_password_msg' => "Re-enter your new password.",
	're_enter_same_password_msg' => "Please re-enter same password.",
	'password_update_success_msg' => "Password updated sucessfully",
	'enter_fname_msg' => "Please enter first name.",
	'enter_email_msg' => "Please enter email.",
	'email_exists_msg' => "Email already exists.",
	'enter_password_msg' => "Please enter password.",
	're_enter_password_msg' => "Please re-enter password.",
	'both_password_same_msg' => "Both password should be same.",
	'select_valid_plan_msg' => "User must have a select valid membership level.",
	'verification_link_send' => "A verification link has been sent to your email address.",
	'account_added_successfully_msg' => "Your account has been added successfully!",
	'saving_data_error_msg' => "There was error while saving data.",
	// 'emb_settings_update_msg' => "Google My Business Settings updated successfully",
	'emb_settings_update_msg' => "Google Business Profile Settings updated successfully",
	'setting_saving_data_error_msg' => "There was error while saving data General Settings",
	'general_settings_updated_msg' => "General Settings updated successfully",
	'fb_settings_update_msg' => "Facebook Settings updated successfully",
	'setting_saving_fb_data_error_msg' => "There was error while saving data Facebook Settings",
	'twitter_settings_update_msg' => "Twitter Settings updated successfully",
	'setting_saving_twitter_data_error_msg' => "There was error while saving data Twitter Settings",
	'youtube_settings_update_msg' => "Youtube Settings updated successfully",
	'setting_saving_youtube_data_error_msg' => "There was error while saving data Youtube Settings",
	'li_settings_update_msg' => "LinkedIn Settings updated successfully",
	'setting_saving_li_data_error_msg' => "There was error while saving data LinkedIn Settings",
	'tum_settings_update_msg' => "Tumblr Settings updated successfully",
	'setting_saving_tum_data_error_msg' => "There was error while saving data Tumblr Settings",
	'pit_settings_update_msg' => "Pinterest Settings updated successfully",
	'setting_saving_pit_data_error_msg' => "There was error while saving data Pinterest Settings",
	'gp_settings_update_msg' => "Google Plus Settings updated successfully",
	'reddit_settings_update_msg' => "Reddit Settings updated successfully",
	'reddit_link_error_msg' => "Please provide a link otherwise posting will not work for Reddit.",
	'setting_saving_gp_data_error_msg' => "There was error while saving data Google Plus Settings",
	'setting_saving_reddit_data_error_msg' => "There was error while saving data Reddit Settings",
	'smtp_settings_update_msg' => "SMTP updated successfully'",
	'setting_saving_smtp_data_error_msg' => "There was error while saving SMTP Settings",
	'stripe_settings_update_msg' => "Stripe settings updated successfully",
	'quick_post_facebook' => "Quick Post scheduled on Facebook",
	'quick_post_twitter' => "Quick Post scheduled on Twitter",
	'quick_post_li' => "Quick Post scheduled on LinkedIn",
	'quick_post_tumb' => "Quick Post scheduled on Tumblr",
	// 'quick_post_gmb' => "Quick Post scheduled on Google My Business",
	'quick_post_gmb' => "Quick Post scheduled on Google Business Profile",
	'quick_post_pit' => "Quick Post scheduled on Pinterest",
	'quick_post_publish_pit' => "Quick Post published on Pinterest",
	'content_scheduled_pit' => "Content scheduled on Pinterest",
	'new_content_published' => "New content has been published",
	'content_draft_save' => "Content draft has been saved",
	'select_post_delete' => "Selected post/s has been deleted",
	'content_scheduled_fb' => "Content scheduled on Facebook",
	'content_scheduled_reddit' => "Content scheduled on Reddit",
	'content_scheduled_twitter' => "Content scheduled on Twitter",
	'content_scheduled_li' => "Content scheduled on LinkedIn",
	'content_scheduled_tumb' => "Content scheduled on Tumblr",
	// 'content_scheduled_gmb' => "Content scheduled on Google My Business",
	'content_scheduled_gmb' => "Content scheduled on Google Business Profile",
	'content_scheduled_instagram' => "Content scheduled on Instagram",
	'content_scheduled_threads' => "Content scheduled on Threads",
	'enter_plan_name' => "Please enter Membership level name.",
	'new_membership_level_success_msg' => "New membership level has been added successfully!",
	'membership_update_success_msg' => "Membership level has been updated successfully!",
	'selected_membership_level_assigned_msg' => "Selected membership level/s not deleted, because of assigned to user/s.",
	'selected_membership_level_delete' => "Selected membership level/s has been deleted",
	'payment_history_delete_msg' => "Selected payment history has been deleted",
	'license_key_email_update' => "License Key & Email are updated successfully",
	'error_saving_license_data' => "There was error while saving license data",
	'your_license_key_is_invalid' => "Your license key is invalid",
	'required_data_blank' => "There was some required data are blank",
	'invalid_access_token' => "Access token is invalid. Please double check the access token.",
	'wrong_token' => "Kindly verify the token again",
	'something_went_wrong' => "Something went wrong",
	'select_customer_msg' => "Please select customer.",
	'select_plan' => "Please select membership level.",
	'select_all' => "Select All",
	'select_none' => "Select None",
	'new_membership_success_msg' => "New membership has been added successfully!",
	'customer_update_success_msg' => "Customer has been updated successfully!",
	'membership_deleted' => "Selected membership has been deleted",
	'subscription_successfully_cancelled' => "Your %s subscription has been successfully cancelled. Your membership will expire on %s.",
	'new_member_success_msg' => "New member has been added successfully!",
	'selected_customers_delete' => "The customer and associated membership has been deleted successfully.",
	'email_verified_successfully' => "Your email address has been verified successfully.",
	'invalid_email_verification_tokan' => "Invalid email verification tokan",
	'selected_logs_deleted' => "Selected logs has been deleted",
	'errorsaving_log' => "There was error while saving log",
	'select_payment_method' => "Please select payment method.",
	'select_checkbox_alert' => "You must select at least one checkbox!",
	'delete_selected_records_conform_msg' => "Are you sure you want to delete selected records?",
	'delete_record_conform_msg' => "Are you sure you want to delete record?",
	'select_bulk_action' => "Please select bulk action!",
	'no_plan_available' => "No membership level available",
	'no_data_available_in_table' => "No data available in table",
	'enter_customer_key' => "Enter Consumer Key",
	'enter_tumblr_key' => "Enter Tumblr Secret Key.",
	'content_share_link' => "Content share link",
	'install_installation_guide_server_req' => "Installation Guide | Server Requirements",
	'install_welcome_title' => "Welcome to setup wizard of Mingle - Social Auto Poster",
	'install_welcome_text' => "This wizard will guide you through the whole installation process",
	'install_step_2_to_7' => "Step 2 of 7 - Server Requirements",
	'install_back' => "Back",
	'install_installation_guide_start' => "Installation Guide | Start",
	'install_installation_already_complate_text' => 'Your installation already completed!, If you want to re-install then please first delete the "mingle-config.php" and make database empty if exist. ',
	'install_welcome_description' => "%s Step 1 of 7 - Start %s %s Welcome to Mingle - Social Auto Poster. Before getting started, we need some information of the database. You will need to know following items before processing.%s %s %s Database name %s %s Database username %s %s Database password %s %s Database host %s %s %s %sThese items were supplied to you by your Web Host. If you don't have this information, then you will need to contact them before you can continue. If you're all ready...</p>",
	'install_lets_go' => "Let's go!",
	'install_continue' => "Continue",
	'install_database_host_error' => "Database host cannot be empty! Please re-enter.",
	'install_database_name_error' => "Database name cannot be empty! Please re-enter.",
	'install_database_username_error' => "Database username cannot be empty! Please re-enter.",
	'install_installation_guide_db' => "Installation Guide | Database Settings",
	'install_step_3_to_7' => "step 3 of 7 - Database Settings",
	'install_database_import' => "Database import",
	'install_required_fields' => "Required fields",
	'install_database_host' => "Database host",
	'install_database_host_help_text' => "%s Database Host %s %s Hostname or IP-address of the database server. The database server can be in the form of a hostname (and/or port address), such as db1.myserver.com, or localhost:5432, or as an IP-address, such as 192.168.0.1 %s",
	'install_database_name_help_text' => "%s Database Name %s %s Database Name. The database used to hold the data. An example of database name is 'testdb'.%s",
	'install_database_username_help_text' => "%s Database Username %s %s Database password. The password is used together with the username, which forms the database user account.%s",
	'install_database_password_help_text' => "%s Database Password%s %s Database password. The password is used together with the username, which forms the database user account.%s",
	'install_database_prefix_help_text' => "%s Database Prefix (optional)%s %s Database prefix. Used to set the unique prefix for database tables and prevent one type of data from interfering with another. An example of database prefix is 'sap_'.%s",
	'install_database_name' => "Database name",
	'install_database_username' => "Database username",
	'install_database_password' => "Database password",
	'install_sap_license_email' => "Mingle - Social Auto Poster email cannot be empty!",
	'install_sap_license_key' => "License key cannot be empty!",
	'install_admin_fname' => "First name cannot be empty!",
	'install_admin_lname' => "Last name cannot be empty!",
	'install_admin_email' => "Admin email cannot be empty!",
	'install_admin_password' => "Your Password Must Contain At Least 8 Characters!",
	'install_admin_ep_not_same' => "Email and Password should not be same!",
	'install_admin_password_not_empty' => "Admin password cannot be empty!",
	'install_admin_email_formate' => "Admin email has wrong format!",
	'install_sap_license_email_format' => "License email has wrong format!",
	'install_installation_admin_account' => "Installation Guide | Administrator Account",
	'install_step_4_to_7' => "Step 4 of 7 - Administrator Account",
	'install_admin_access_info' => "Admin Access Info",
	'sap_license_email' => "License email",
	'license_email' => "License email",
	'admin_email' => "Admin email",
	'admin_password' => "Admin password",
	'char_count' => "Characters",
	'sap_license_key_placeholder' => "License Key",
	'sap_license_key' => "License Key",
	'install_admin_email_help_text' => "%s Admin Email %s %s Admin Email that will be replaced in SQL dump with email placeholder (if defined).%s",
	'install_license_email_help_text' => "%s License Email %s %s License Email that will be replaced in SQL dump with email placeholder (if defined).%s",
	'install_admin_username_help_text' => "%s Admin Login %s %s Your username must be at least 6 characters long and case-sensitive. Please do not enter accented characters.%s",
	'install_admin_password_help_text' => "%s Admin Password %s %s We recommend that your password is not a word you can find in the dictionary, Password should be 8 characters long as well as it should contain the capital , lower case letters, at least one digit and one special character (1-9, !, *, _, etc.).%s",
	'install_license_key_help_text' => "%s Codecanyon License key %s %sYou can find Codecanyon purchase code from your Codecanyon account.%s",
	'install_installation_rti' => "Installation Guide | Ready to Install",
	'install_step_5_to_7' => "Step 5 of 7 - Validate license",
	'install_step_5_help_text' => "Verify your license here",
	'install_step_6_help_text' => "All right, sparky! You have made it through this part of the installation. Mingle - Social Auto Poster can now communicate with your database. If you are ready, time now to...",
	'install' => "Install",
	'install_installation_complate' => "Installation Guide | Complete Installation",
	'install_step_6_to_7' => "Step 6 of 7",
	'install_step_7_to_7' => "Step 7 of 7",
	'install_db_error' => "- Database Import (error)",
	'install_db_completed' => "- Completed",
	'install_installation_completed' => "Installation Completed!",
	'install_security_msg' => "For security reasons, please remove %s/install%s folder from your server!",
	'install_proceed_to_login_page' => "Proceed to login page",
	'localhost' => "Localhost",
	'install_menu_start' => "Start",
	'install_menu_server_requirements' => "Server Requirements",
	'install_menu_db_settings' => "Database Settings",
	'install_menu_admin_account' => "Administrator Account",
	'add_license' => "License",
	'install_menu_ready_to_install' => "Ready to Install",
	'install_menu_completed' => "Completed",
	'cancelled_membership_email_notif'=>"Cancelled Membership Email Notification",
	'cancelled_membership_email_notif_help_text'=>"The subject line for the email sent to customers when their membership is cancelled.",
	'cancelled_membership_email_notif_content_help_text'=>"The content for the email sent to customers when their membership is cancelled.%s %s{user_name}%s - Display Username %s %s{membership_level}%s - Display membership level %s %s{expiration_date}%s - Display expiration date",
	'expired_membership_email_notif'=>"Expired Membership Email Notification",
	'expired_membership_email_notif_help_text'=>"The subject line for the email sent to users when their membership is expired.",
	'expired_membership_email_notif_content_help_text'=>"The content for the email sent to users when their membership is expired.%s %s{user_name}%s - Display Username %s %s{membership_level}%s - Display membership level",
	'plan_upgraded_successfully'=>"Your membership level has been upgraded successfully.",
	'customer_membership_purchased' =>"This customer do not have any membership purchased.",
	'install_php_version_check' => "This program requires at least version %s of PHP installed (current version is %s). You cannot proceed the installation.",
	'install_failed' => "failed",
	'install_passed' => "passed",
	'install_db_version_check' => "This program requires at least version %s of %s installed (current version is %s). You cannot proceed the installation.",
	'install_db_test_connection' => "Test Connection",
	'install_complete_installation_host_error' => "Database host cannot be empty! Please re-enter.",
	'install_complete_installation_name_error' => "Database name cannot be empty! Please re-enter.",
	'install_complete_installation_username_error' => "Database username cannot be empty! Please re-enter.",
	'install_complete_installation_db_version' => "This program requires at least version %s of %s installed (current version is %s). You cannot proceed the installation.",
	'install_complete_installation_wrong_parameter' => "Wrong parameter passed! Please back to the previous step and try again.",
	'install_footer' => "%s Copyright %s %s %s WPWeb Infotech Private Limited %s.%s All rights reserved.",
	'footer' => "%s Copyright %s %s %s WPWeb Infotech Private Limited %s| All Rights Reserved. %s",
	'install_footer_version' => "Version",
	'install_db_class' => "You must have PHP 5 or newer installed to use PHP Data Objects (PDO) extension",
	'social_fbconfig_graph_error' => "Graph returned an error:",
	'social_fbconfig_sdk_error' => "Facebook SDK returned an error:",
	'select_shortener_type' => "Select Shortener Type",
	'select_shortener_tinyURL' => "TinyURL",
	'select_shortener_bitly' => "bit.ly",
	'select_shortener_shortest' => "shorte.st",

	'update_email_key_error' => "Please first enter your email and license key",
	'update_email_address_error' => "Please enter your email address",
	'update_token_error' => "Please enter your Access Token",
	'update_key_error' => "Please enter your license key",
	'update_not_save' => "Could not save new update. Operation aborted.",
	'update_version_success' => "New version has been updated successfully.",
	'update_fail' => "Something goes wrong",
	'update_script_up_to_date' => "Your Script now up to date",
	'allowed_networks' => "Allowed Networks",
	'total' => "Total",
	'next_renewal_due' => "Next Renewal Due",
	'make_payment' => "Make Payment",
	'quick_single_post' => "Quick Posting",
	'debug_logs'=>"Debug Logs",
	'membership_levels' =>"Membership Levels",
	'memberships'=>"Memberships",
	'check_update' =>"Check Update",
	'my_account' => "My Account",
	'settings' => "Settings",
	'select_button_type' => 'Select Button Type',
	'update_loader' => 'Update',
	'cancelled_membership_notice_message' => 'Your %s has been cancelled. Your membership will expire on %s.',
	'discounts_and_fees' => 'Discounts and Fees',
	'proration_credit' => 'Proration Credit (Discount)',
	'edit' => 'Edit',
	'start_date' => 'Start Date',
	'membership_start_date' => 'Please select membership start date',
	'membership_upgrede_message' => 'If you upgrade your account, the new membership will be prorated up to %s for the first payment. Prorated prices are shown below.',
	'expiration_and_renewal_date' => 'Expiration/Renewal Date',
	'cancel_membership_alert' => 'Are you sure you want to cancel your %s subscription?',
	'membership_auto_renew_note' => '%s Note: %s If the customer has a membership with auto-renew enabled, then editing the expiration date may not change their next billing date with the payment processor.',
	
	'membership_status_tooltrip' => 'Active memberships have access to restricted content. Members with a status of Cancelled may continue to access restricted content until the expiration date on their account is reached. When a user reaches his or her expiration date, their status is updated to Expired.',
	'membership_expired_message' => 'Membership has been expired',
	'membership_cancel_message' => 'Membership has been cancelled',
	'your_subscription' => 'Your Subscription',
	'customer_id' => 'Gateway Customer ID',
	'subscription_id' => 'Gateway Subscription ID',
	'add_payment' => 'Add Payment',
	'payment_details' => 'Payment Details',
	'auto_renew_note' => '%s Note: %s Changed on Auto renew does not actually create a subscription at the payment gateway. This should only be checked on if you\'ve already separately set up a recurring subscription at the gateway.',
	'enter_payment_date' => 'Please enter Payment date',
	'enter_amount' => 'Please enter amount',
	'new_payment_success_msg' => "New payment has been added successfully!",
	'edit_payment_success_msg' => "Payment has been updated successfully!",
	'failed' => "Failed",
	'edit_payment' => "Edit payment",
	'back_to_payment_page' => "Back to payment page",
	'memberships_update_success_msg' => "Membership has been updated successfully!",
	'completed' => 'Completed',
	'pending' => 'Pending',
	'failed' => 'Failed',
	'refunded' => 'Refunded',

	'instagram_general_title' => 'General Settings',
	'instagram_autoposting' => "Enable Autoposting",
	'instagram_autoposting_help' => "Enable this button, if you want to automatically post your new content to Instagram.",
	'autopost_to_instagram' => "Autopost Settings",
	'autopost_to_insta_users' => "Autopost Posts to Instagram of this user(s)",
	'autopost_to_insta_users_help' => "Select each of the users that you want to automatically post to Instagram when a new post is published.",
	'inst_post_img' => "Instagram Post Image",
	'instagram_settings_update_msg' => 'Instagram settings updated successfully',
	'instagram_quick_post_facebook_help_text' => 'Please set Instagram grant extended permissions for publishing content on Facebook account.',
	'reddit_quick_post_help_text' => 'Please set Reddit grant extended permissions for publishing content on Reddit account.',
	'quick_post_instagram' => "Quick Post scheduled on Instagram", 
	'quick_post_reddit' => "Quick Post scheduled on Reddit", 
	'post_to_instagram' => "Post To This Instagram",

	'threads_add_account'	=> 'Add Threads Account',
	'threads_general_title' => 'General Settings',
	'threads_autoposting' => "Enable Autoposting",
	'threads_autoposting_help' => "Enable this button, if you want to automatically post your new content to Threads.",
	'autopost_to_threads' => "Autopost Settings",
	'autopost_to_threads_users' => "Autopost Posts to Threads of this user(s)",
	'autopost_to_threads_users_help' => "Select each of the users that you want to automatically post to Threads when a new post is published.",
	'threads_post_img' => "Threads Post Image",
	'threads_settings_update_msg' => 'Threads settings updated successfully',
	'threads_quick_post_facebook_help_text' => 'Please set Threads grant extended permissions for publishing content on Threads account.',
	'reddit_quick_post_help_text' => 'Please set Reddit grant extended permissions for publishing content on Reddit account.',
	'quick_post_threads' => "Quick Post scheduled on Threads", 
	'quick_post_reddit' => "Quick Post scheduled on Reddit", 
	'post_to_threads' => "Post To This Threads",

	'blogger_general_title' => 'Blogger General Settings',
	'blogger_autoposting' => "Enable Autoposting",
	'blogger_autoposting_help' => "Enable this button, if you want to automatically post your new content to Blogger.",
	'blogger_settings_update_msg' => "Blogger Settings updated successfully",
	'setting_saving_blogger_data_error_msg' => "There was error while saving data Blogger Settings",
	'blogger_api_setting' => "Blogger API Settings",
	'blogger_add_account' => "Add Blogger Account",
	'quick_post_blogger' => "Quick Post scheduled on Blogger",
	'content_scheduled_blogger' => "Content scheduled on Blogger",
	'autopost_to_blogger' => "Autopost To Blogger",
	'autopost_to_blogger_users' => "Autopost Posts to Blogger of this user(s)",
	'autopost_to_blogger_users_help' => "Select each of the users that you want to automatically post to Blogger when a new post is published.",
	'blogger_post_img' => "Blogger Post Image",
	'blogger_post_img_remove' => "Remove Blogger Image",
	'blogger_url' => "Blogger Url",
	'quick_post_blogger_cnofig_msg' => "Please configure Google account for publishing post on Blogger.",
	'blogger_post_status_note' => "Status of Blogger post i.e. published/unpublished/scheduled.",
	'post_to_blogger' => "Post To This Blogger Account(s)",
	'post_to_account_note' => "Select an account to which you want to Post. This setting overrides the general settings. Leave it empty to use the general default settings.",
	'blogger_post_image_note' => "Here you can upload an image which will be used as a Blogger banner Image. Leave it empty to use the general default settings.",
	'blogger_custom_message' => "Blogger Title",
	'blogger_title_note' => "Here you can enter a title which will be used as the blogger title.",
	'blogger_post_url' => "Blogger Url",
	'blogger_url_note' => "Here you can enter a url of your blogger site which will be used to post a data.",
	'blogger_account_error' => "Please Select Blogger User(s)",
	'try_again_later' => "Something went wrong please try again",
	'blogger_account_not_select' => "Blogger posting users are not selected.",
	'something_went_wrong_debug' => "Something went wrong please check Debug Logs section for more details.",
	'misc_settings' => "Misc Settings",
	'enable_relative_path' => "Enable Relative Path",
	'misc_en_checkbox' => "Slide the button to use the relative path for images when posting to social media.",
	'settings_update_msg' => "Settings updated successfully",
	'add_coupon' => 'Add Coupon',
	'coupon_details' => 'Coupon Details',
	'coupon_code'	=> 'Coupon Code',
	'coupon_type'	=> 'Discount Type',
	'fixed'			=> 'Fixed',
	'percentage'	=> 'Percentage',
	'coupon_amount' => 'Amount',
	'coupon_description' => 'Description',
	'coupon_expiry_date' => 'Expiry Date',
	'coupon_status' => 'Status',
	'enter_coupon_code' => 'Please enter coupon code',
	'select_coupon_type' => 'Please select coupon type',
	'enter_coupon_amount' => 'Please enter coupon amount',
	'enter_coupon_amount_percentage' => 'Enter Coupon Percentage Amount Between 1 to 100',
	'select_coupon_status' => 'Select Coupon Status',
	'new_coupon_success_msg' => "New coupon has been added successfully!",
	'coupons' => "Coupons",
	'coupon_delete_msg' => "Selected coupon has been deleted",
	'edit_coupon' => "Edit coupon",
	'edit_coupon_success_msg' => "Coupon has been updated successfully!",
	'enter_unique_coupon_code' => 'Coupon Code with this name already exist, please use another code name',
	'apply_coupon' => 'Apply Coupon Code',
	'coupon_name' => 'Coupon Name',
	'discount_amount' => 'Discount Amount',
	'total_amount' => 'Total Amount',
	'payable_amount' => 'Payable Amount',
	'coupon_code_is_not_valid' => 'Coupon code is not valid',
	'coupon_code_is_applied_successfully' => 'Coupon code is applied successfully',
	'cupon_code_is_expired' => 'Coupon code is expired',
	'this_coupon_code_is_already_used' => 'This coupon code is already used',
	'individual_schedule' => 'Schedule Individually',
	'schedule_global' => 'Schedule Global',
	'schedule_individual' => 'Schedule Individually',
	'custom_message' => 'Custom Message',
	'ai_message' => 'AI Message',
	'caption_words' => 'Words',
	'api_key_setting_heading' => 'ChatGPT Settings',
	'desction_for_api_key_input_field' => 'Enter your OpenAI key here.',
	'enter_api_key' => 'Enter OpenAI Key',
	'register_licence' => "Register Licence",
	'admin_licence_not_register' => "Licence Not Registered",
	'license_and_updates' => 'License & Updates',
	'site_name' => 'Site Name',
	'meta_title' => 'Meta Title',
	'meta_description' => 'Meta Description',
	'description_for_site_name_input_field' => 'Enter a site title here.',
	'description_for_meta_title_input_field' => 'Enter a meta title here.',
	'failed_to_find_inner_main_source_file' => 'Failed to find the inner main source file.',
	'failed_to_open_the_zip_file' => 'Failed to open the ZIP file.',
	'failed_to_find_the_main_source_file_from_source_zip' => 'Failed to find the main source file from source zip.',
	'page_auto_refresh_after_the_success_update_msg' => 'While update in progress please do not refresh the page or close this tab to avoid any issue with updating mingle.',
	'access_token_steps' => '<p><b>Please follow the steps below:</b></p><ol><li>Generate an Envato API Personal Token by <a href="https://build.envato.com/create-token/?default=t&purchase:download=t&purchase:list=t" target="_blank">clicking this link</a>.</li><li>Name the token e.g. "My Mingle".</li><li>Ensure the following permissions are enabled:</li><ul><li>View and search Envato sites</li><li>Download your purchased items</li><li>List purchases you`ve made</li></ul><li>Copy the token into the box below.</li><li>Click the "Save Changes" button.</li></ol>',
	'description_for_meta_desc_input_field' => 'Enter a meta description here.',
	'network_label_nos_of_ac' => "Number of accounts",
	'network_label_wordpress' => 'Wordpress',
	'limited_ac_info_bk' => 'Leave it empty for unlimited accounts.',
	'limited_ac_info' => 'Enter number of account or leave it empty for unlimited accounts.',
	'wordpress_general_title' => 'Wordpress General Settings',
	'wordpress_autoposting' => "Enable Autoposting",
	'wordpress_autoposting_help' => "Enable this button, if you want to automatically post your new content to Wordpress.",
	'wordpress_api_setting' => "WordPress Websites Settings",
	'wordpress_settings_update_msg' => "Wordpress Settings updated successfully",
	'setting_saving_wordpress_data_error_msg' => "There was error while saving data Wordpress Settings",
	'website_name' => "Website Name",
	'reddit_communities' => "Reddit communities",
	'website_name_plh_text' => "Enter Website Name.",
	'website_url' => "Website URL",
	'website_url_plh_text' => "Enter Website URL.",
	'website_unm' => "Website Username",
	'website_unm_plh_text' => "Enter Website Username.",
	'website_pwd' => "Website Password",
	'website_pwd_plh_text' => "Enter Website Password.",
	'map_wordpress_post_types' => "Map WordPress post types",
	'account_limit' => "You reached your account Limit",
	'max_account_limit_note' => "%s Note: %s You have a maximum of %s accounts allowed",
	'single_account_limit_note' => "%s Note: %s You have only %s account to add",
	'max_account_limit_alert' => "%s Alert: %s You've reached the maximum of %s accounts",
	'single_account_limit_alert' => "%s Alert: %s You've reached the maximum of %s account",
	'add_website' => "Add Website",
	'wordpress_custom_message'=> 'Post Title',
	'post_to_wordpress_account' => "Post To This Wordpress site",
	'quick_post_wordpress' => "Quick Post scheduled on Wordpress",
	'content_scheduled_wordpress' => "Content scheduled on Wordpress",
	'map_post_types' =>'Map Post Types',
	'map_flair' =>'Map Flair',
	'select_flair' =>'Select Flair',
	'map_your_flair' =>'Map your Flair',
	'post_types' =>'Post Types',
	'wordpress_post_img' => "Wordpress Post Image",
	'wordpress_post_img_remove' => "Remove Wordpress Image",
	'autopost_to_wodpress' => "Autopost Settings",
	'db_update_inprogrss' => 'Database upgradation process in progress, please don\'t referesh the page till the process completed.',
	'updated_records' => 'Updated records',
	'flash_db_updated_success' => 'Mingle Database Updated %s Successfully %s',
	'flash_message_write_permission' => "Please provide the write permission to the directory ( %s )",
	'flash_message_db_update' => "Mingle database update required. To keep things running smoothly, we have to update your database to the newest version. %s",
	'flash_message_remove_install_folder' => "For security reasons, please remove /install folder from your server!",
	'flash_message_update_access_token' => "Please update your access token to get automatic updates.",
	'flash_message_fb_graphapi_update' => "Our Facebook Graph API configurations has been updated. Please reconnect your Facebook account.",
	'ph_membership_level' =>'Ex: Gold',
	'ph_price' =>'Ex: 1000',
	'ph_description' =>'Ex: Write something here...',
	'ph_network_count' =>'Ex: 10',
	'ph_first_name' =>'Ex: John',
	'ph_last_name' =>'Ex: Doe',
	'ph_name' =>'Ex: John Doe',
	'ph_email' =>'Ex: johndoe@example.com',
	'ph_smtp_host' =>'Ex: smtp.example.com',
	'ph_smtp_port' =>'Ex: 123',
	'ph_password' =>'********',
	'ph_date' =>'YYYY-MM-DD',
	'ph_coupon_code' =>'Ex: ABC123',
	'required_size_logo_text' =>'Required image size : %s (130x45) %s',
	'required_size_icon_text' =>'Required icon size : %s (16x16) %s',
	'xml_rpc_notice' => "%s Notice : %s We are sorry, but it seems that XML-RPC is currently disabled on this server. To enable XML-RPC on your server, please contact your hosting provider or server administrator.",
	
	
);